/* $Id: ncat_core.h 11806 2009-01-22 00:38:21Z david $ */

#include "nsock.h"
#include "nbase.h"

extern struct sockaddr_storage srcaddr;
extern size_t srcaddrlen;
extern struct sockaddr_storage targetss;
extern size_t targetsslen;

extern struct sockaddr_storage httpconnect;
extern struct sockaddr_storage socksconnect;

extern int verbose_flag;

struct options {
    unsigned short portno;

    int af;
    int broker;
    int listen;
    int sendonly;
    int recvonly;
    int telnet;
    int udp;
    int linedelay;
    int talk;
    int nodns;
    int normlogfd;
    int hexlogfd;
    int idletimeout;
    int crlf;
    char *allow;
    char *allowfile;
    char *deny;
    char *denyfile;
    int httpserver;

    /* Loose source-routing stuff */
    struct in_addr srcrtes[8];
    int numsrcrtes;
    int srcrteptr;

    /* Maximum number of simultaneous connections */
    int conn_limit;
    int conntimeout;

    char *cmdexec;
    int shellexec;
    unsigned char *proxy_auth;
    char *proxytype;

#ifdef HAVE_OPENSSL
    int ssl;
    char *sslcert;
    char *sslkey;
#endif
};

extern struct options o;

/* Initializes global options to their default values. */
void options_init(void);

/* Tries to resolve the given name (or literal IP) into a sockaddr
   structure.  The af should be PF_INET (for IPv4) or PF_INET6.  Returns 0
   if hostname cannot be resolved.  It is OK to pass in a sockaddr_in or 
   sockaddr_in6 casted to a sockaddr_storage as long as you use the matching 
   pf.*/
extern int resolve(char *hostname, struct sockaddr_storage *ss,
		   size_t *sslen, int pf);

/* Take a file descriptor to redirect to and a command to execute.
 * Redirect file descriptor, stdin & stdout, not stderr.
 */
extern int netexec(int fd, char *cmdexec);

/* Do telnet WILL/WONT DO/DONT negotiations */
extern void dotelnet(int s, unsigned char *buf, size_t bufsiz);

/* Set verbosity level for Ncat and nsock */
extern int verbosity(int verbose_flag, nsock_pool mypool);

/* Return 1 if user is root, otherwise 0. */
extern int ncat_checkuid();

/* sleep(), usleep(), msleep(), Sleep() -- all together now, "portability".
 * 
 * There is no upper or lower limit to the delayval, so if you pass in a short 
 * length of time <100ms, then you're likely going to get odd results. 
 * This is because the Linux timeslice is 10ms-200ms. So don't expect 
 * it to return for atleast that long.
 * 
 * Block until the specified time has elapsed, then return 1.
 */
extern int ncat_delay_timer(int delayval);

/* Open a logfile for writing.
 * Return the open file descriptor. */
extern int ncat_openlog(char *logfile);

/* Convert session data to a neat hexdump logfile */
extern int ncat_hexdump(int logfd, char *data, int len);

extern int ncat_hostaccess(char *matchaddr, char *filename, char *remoteip);

