/* $Id: ncat_proxy.h 11504 2008-12-24 20:18:15Z kris $ */

/* 
 * Return the HTTP/1.1 proxy request to send to an 
 * HTTP proxy server. See docs/HTTP-PROXY for more
 * information about this HTTP request and what to
 * do if you find it doesn't work for you or your
 * proxy server. 
 *
 * Return finalized HTTP/1.1 proxy request.
 *
 * If proxy_auth is NULL, HTTP Proxy-Authorization
 * headers are not included in the request.
 * 
 */
extern char *ncat_http_proxy(unsigned char *proxy_auth);

/* Simple forking HTTP proxy
 *
 * IPv6 address requests should be within [].  This is to help deal with
 * the host:port separator.  E.g. [::1]:80
 *
 */
extern int ncat_http_server(void);

/* 
 * Handle SOCKS4 CD field error reporting.
 * Return the error message to be used in
 * the final Ncat output. (It's final because
 * these are all fatal errors.) 
 *
 * See: http://archive.socks.permeo.com/protocol/socks4.protocol
 * 
 * These error messages are taken verbatim from socks4.protocol (above)
 */
extern char *socks4_error(char cd);
