/* utility functions */

/* $Id: util.h 11504 2008-12-24 20:18:15Z kris $ */

#ifndef UTIL_H_
#define UTIL_H_

#include "ncat.h"
#include "nbase.h"
#ifndef WIN32
#include <sys/types.h>
#include <netinet/in.h>
#endif

#ifdef HAVE_OPENSSL
#include <openssl/ssl.h>
#endif

int isip(char *host);

/* add/multiply unsigned values safely */
size_t sadd(size_t, size_t);
size_t smul(size_t, size_t);

#ifdef WIN32
void windows_init();
#endif

/* handle errors */
void die(char *);

void bye(const char *, ...);

/* zero out some memory, bzero() is deprecated */
void zmem(void *, size_t);

const char *inet_socktop(struct sockaddr_storage *);

unsigned short inet_port(struct sockaddr_storage *);

int do_listen(int);

char *buildsrcrte(struct in_addr dstaddr, struct in_addr routes[],
                  int numroutes, int ptr, size_t *len);

int allow_access(struct sockaddr_storage *);

struct fdinfo {
	int fd;
#ifdef HAVE_OPENSSL
	SSL *ssl;
#endif
};

typedef struct fd_list {
	struct fdinfo *fds;
	int nfds, maxfds, fdmax;
} fd_list_t;

int add_fd(fd_list_t *, int, void*);
int rm_fd(fd_list_t *, int);
void free_fdlist(fd_list_t *);
void init_fdlist(fd_list_t *, int);
int get_maxfd(fd_list_t *);
struct fdinfo *get_fdinfo(fd_list_t *, int);

#endif

