@echo off

echo Setting installation variables...
set PythonEXE=C:\Python26\python.exe
set DistDir=dist
set LibraryDir=%DistDir%\py2exe
set GTKDir=C:\GTK
set WinInstallDir=install_scripts\windows
set Output=win_install.log
set UtilsDir=install_scripts\utils

IF EXIST %PythonEXE% GOTO GGTK
ECHO No Python 2.6 found!
EXIT 1

:GGTK
IF EXIST %GTKDir% GOTO GWin
ECHO No GTK found!
EXIT 1

:GWin
IF EXIST %WinInstallDir% GOTO GUtils
ECHO No Windows install scripts found!
EXIT 1

:GUtils
IF EXIST %UtilsDir% GOTO GWork
ECHO No utils directory found!
EXIT 1

:GWork

echo Writing output to %Output%

echo Removing old compilation...
IF EXIST %DistDir% rd %DistDir% /s /q > %Output%

echo Creating dist and dist\share directories...
mkdir %LibraryDir%\share
mkdir %LibraryDir%\share\gtk-2.0
mkdir %LibraryDir%\share\gtkthemeselector
mkdir %LibraryDir%\share\themes
mkdir %LibraryDir%\share\themes\Default
mkdir %LibraryDir%\share\themes\MS-Windows
mkdir %LibraryDir%\share\xml


echo Copying GTK's share to dist directory...
xcopy %GTKDir%\share\gtk-2.0\*.* %LibraryDir%\share\gtk-2.0\ /S >> %Output%
xcopy %GTKDir%\share\gtkthemeselector\*.* %LibraryDir%\share\gtkthemeselector\ /S >> %Output%
xcopy %GTKDir%\share\themes\Default\*.* %LibraryDir%\share\themes\Default /S >> %Output%
xcopy %GTKDir%\share\themes\MS-Windows\*.* %LibraryDir%\share\themes\MS-Windows /S >> %Output%
xcopy %GTKDir%\share\xml\*.* %LibraryDir%\share\xml\ /S >> %Output%
xcopy %GTKDir%\bin\*.dll %LibraryDir% /S >> %Output%

echo Compiling using py2exe...
%PythonEXE% setup.py py2exe >> %Output%

echo Copying some more GTK files to dist directory...
xcopy %GTKDir%\lib %LibraryDir%\lib /S /I >> %Output%
xcopy %GTKDir%\etc %LibraryDir%\etc /S /I >> %Output%


echo Removing the build directory...
rd build /s /q >> %Output%


echo Done!

